using System;
using System.Data;
using System.Collections;
using gov.va.med.vbecs.Common;
using System.Data.SqlTypes;
using System.Data.SqlClient;
using MethodBase = System.Reflection.MethodBase;
using gov.va.med.vbecs.ExceptionManagement;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

namespace gov.va.med.vbecs.DAL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Cameron Taylor</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>04/12/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	/// SpecimenTest data access layer class.
	///</summary>

	#endregion
	
	public class SpecimenTest
	{

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1383"> 
		///		<ExpectedInput>Supplier Guid</ExpectedInput>
		///		<ExpectedOutput>DataRow of address information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1384"> 
		///		<ExpectedInput>Invalid DataTables</ExpectedInput>
		///		<ExpectedOutput>ArgumentException</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="1388"> 
		///		<ExpectedInput>Invalid RowVersions</ExpectedInput>
		///		<ExpectedOutput>RowVersionExceptions</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Public static function invalidates specimen test results, and optionally updates
		/// the task status to allow for re-entry (UC_94)
		/// </summary>
		/// <param name="specimenTestResults">Specimen test table</param>
		/// <param name="orderedTest">Ordered test table (optional)</param>
		/// <param name="dtWorkloadEvent">WorkloadEventdata</param>
		/// <param name="dtTransfusionReqs">Transfusion Requirements</param>
		/// <param name="dtPatient">Patient data table</param>
		/// <param name="antiseraOrderedTests">Antisera Ordered Test table</param>
		/// <param name="lastUpdateFunctionId">Last update function ID</param>
		/// <returns>Success indicator</returns>
		public static bool InvalidateSpecimenTestResults(DataTable specimenTestResults, DataTable orderedTest, DataTable dtWorkloadEvent, DataTable dtTransfusionReqs,
			DataTable dtPatient, DataTable antiseraOrderedTests, Common.UpdateFunction lastUpdateFunctionId)
		{
			Common.Utility.RequireNonNullColumns(specimenTestResults, STOREDPROC.UpdateSpecimenTestStatus.RequiredParameters);
			//
			if ((orderedTest != null) && (orderedTest.Rows.Count>0))
			{
				Common.Utility.RequireNonNullColumns(orderedTest, STOREDPROC.UpdateOrderedTestStatus.RequiredParameters);
			}
			//
			ArrayList dtArray = new ArrayList();
			ArrayList spArray = new ArrayList();
			//
			dtArray.Add(Common.Utility.AppendLastUpdateInformation(specimenTestResults, lastUpdateFunctionId));
			spArray.Add(STOREDPROC.UpdateSpecimenTestStatus.StoredProcName);
			//
			if (orderedTest != null) 
			{
				if(orderedTest.Rows.Count>0)
				{
					dtArray.Add(Common.Utility.AppendLastUpdateInformation(orderedTest, lastUpdateFunctionId));
					spArray.Add(STOREDPROC.UpdateOrderedTestStatus.StoredProcName);
				}
			}

			if(dtWorkloadEvent != null)
			{
				if(dtWorkloadEvent.Rows.Count > 0)
				{
					dtArray.Add(Common.Utility.AppendLastUpdateInformation(dtWorkloadEvent, lastUpdateFunctionId));
					spArray.Add(STOREDPROC.InsertWorkloadEvents.StoredProcName);
				}
			}

			if (dtTransfusionReqs != null)
			{
				if (dtTransfusionReqs.Rows.Count>0)
				{
					dtArray.Add(Common.Utility.AppendLastUpdateInformation(dtTransfusionReqs, lastUpdateFunctionId));
					spArray.Add(STOREDPROC.UpdateTransfusionRequirements.StoredProcName);
				}
			}

			if (dtPatient != null)
			{
				if (dtPatient.Rows.Count>0)
				{
					dtArray.Add(Common.Utility.AppendLastUpdateInformation(dtPatient, lastUpdateFunctionId));
					spArray.Add(STOREDPROC.UpdatePatientAboRHChangeIndicator.StoredProcName);
				}
			}

			if (antiseraOrderedTests != null)
			{
				if (antiseraOrderedTests.Rows.Count>0)
				{
					dtArray.Add(Common.Utility.AppendLastUpdateInformation(antiseraOrderedTests, lastUpdateFunctionId));
					spArray.Add(STOREDPROC.UpdateAntiseraOrderedTestStatus.StoredProcName);
				}
			}
			//
			int result = new StoredProcedure().TransactionalGetValue(spArray, dtArray);

			return (result == 0);
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/24/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5453"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing OffSiteABID data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5454"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get the list of ABIDs performed off-site for a date range
		/// </summary>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataTable GetOffSiteAntibodyIDs(DateTime startDate, DateTime endDate) 
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetOffsiteABID.startdate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetOffsiteABID.enddate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetOffsiteABID.divisioncode, System.Data.SqlDbType.Char,5)
			};
				
			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;
				
			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetOffsiteABID.StoredProcName, prms);
			return ds.Tables[0];
		}

	}
}
